!BossHP = $18E6|!addr
!BossHits = 15

; Tile Number, xPos, yPos, YXPPCCCT, Size.

!A = #$29
!B = #$38
!C = #$39
!D = #$44
!E = #$45
!F = #$46
!G = #$47
!H = #$48
!I = #$49
!J = #$54
!K = #$55
!L = #$56
!M = #$57
!N = #$58
!O = #$59
!P = #$D4
!Q = #$CE
!R = #$CF
!S = #$DE
!T = #$DF
!U = #$88
!V = #$89
!W = #$98
!X = #$99
!Y = #$C2
!Z = #$C3
!Ex = #$D2
!Qu = #$D3 
; Tile Number, xPos, yPos, YXPPCCCT, Size.

init:

	LDA #$01		;\  Force Big Mario
	STA $19			;/
	;
	REP   #$20 ; 16-bit A

	; Set transfer modes.
	LDA   #$3202
	STA   $4330 ; Channel 3
	LDA   #$3200
	STA   $4340 ; Channel 4

	; Point to HDMA tables.
	LDA   #Gradient1_RedGreenTable
	STA   $4332
	LDA   #Gradient1_BlueTable
	STA   $4342

	SEP   #$20 ; 8-bit A

	; Store program bank to $43x4.
	PHK
	PLA
	STA   $4334 ; Channel 3
	STA   $4344 ; Channel 4

	; Enable channels 3 and 4.
	LDA.b #%00011000
	TSB   $0D9F|!addr

	RTL ; <-- Can also be RTL.

; --- HDMA Tables below this line ---
Gradient1_RedGreenTable:
db $0C,$25,$4D
db $0C,$26,$4D
db $01,$26,$4E
db $08,$27,$4E
db $03,$28,$4E
db $06,$28,$4F
db $06,$29,$4F
db $03,$29,$50
db $0D,$2A,$50
db $04,$2B,$50
db $22,$2B,$51
db $0A,$2C,$51
db $07,$2C,$52
db $0E,$2D,$52
db $01,$2D,$53
db $10,$2E,$53
db $07,$2F,$53
db $13,$2F,$54
db $30,$30,$54
db $00

Gradient1_BlueTable:
db $80,$9E
db $60,$9E
db $00

; Data for the sprite tiles
FilledTiles:
    db $C0, $C1, $D0
EmptyTiles:
    db $E8, $E9, $F8

main:
    ; Draw the father
    rep #$10
    %maxtile(!T, #5, #$CB, #$30, #$00, "max")
    %maxtile(!H, #12, #$CB, #$30, #$00, "high")
    %maxtile(!E, #19, #$CB, #$30, #$00, "high")
    %maxtile(!F, #33, #$CB, #$30, #$00, "high")
    %maxtile(!A, #40, #$CB, #$30, #$00, "high")
    %maxtile(!T, #47, #$CB, #$30, #$00, "high")
    %maxtile(!H, #54, #$CB, #$30, #$00, "high")
    %maxtile(!E, #61, #$CB, #$30, #$00, "high")
    %maxtile(!R, #68, #$CB, #$30, #$00, "high")
    
    ; X = tile currently being drawn
    ldx.w #$00
    ; Y = sprite tile offset into FilledTiles
    ldy.w #$00
    ; $00 = X position
    lda.b #$05
    sta.b $00
    ; Main loop
.loop:
    ; Compare to Boss HP
    cpx.w !BossHP
    ; Switch to empty tiles if necessary
    bne + : iny #3 : +
    ; Draw the tile
    phx
    %maxtile("FilledTiles,y", $00, #$D3, #%00111000, #$00, "high")
    plx
    ; Check if we're drawing the first tile, and switch to the second
    cpx.w #$00
    bne + : iny : +
    ; Check if we're drawing the next-to-last tile, and switch to the third
    cpx.w #!BossHits-2
    bne + : iny : +
    ; Increment position
    lda.b $00
    clc : adc.b #$07
    sta.b $00
    ; Check if we're done
    inx
    cpx.w #!BossHits
    bne .loop
    sep #$30
    rtl